/******************************************************************************

	FindWindowSize.cp
	
	Manuel A. Perez
	
	Most of this code was "borrowed" from TCL routines...  very little
	was added.

 ******************************************************************************/
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include <Global.h>
#include <Commands.h>
#include <CApplication.h>
#include <CBartender.h>
#include <CDataFile.h>
#include <CResFile.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <CError.h>
#include <CPanorama.h>
#include <CScrollPane.h>
#include <TBUtilities.h>
#include <CWindow.h>

#include "FindWindowSize.h"

void	FindWindowSize(CWindow *theWindow, Rect *theRect)
{
	GrafPtr				macPort;
    register WindowPeek macWPeek;       /* Toolbox Window Record            */
	short				hPos;			/* Horizontal location for window	*/
	short				vPos;			/* Vertical location for window		*/
    Rect                structRect;     /* Bounds of window's strucRgn      */
    Point               portTopLeft;    /* Top left of window's portRect    */
    GrafPtr             savePort;       /* Need to save and restore port    */
    short				vDivisor;		/* divisor to use to calculate the  */
    									/* window's vertical position 		*/
    short				hMbar;			// TCL 1.1.3 12/7/92 BF
    					
    
    /* Center the structure region of the window on the main    */
    /* screen, which is defined by screenBits.bounds.           */
    
    macPort = theWindow->GetMacPort();
    macWPeek = (WindowPeek) macPort;
   
                                        /* strucRgn gives the overall size  */
                                        /* of a window                      */
    structRect = (**(macWPeek->strucRgn)).rgnBBox;
    
        /* Now we need to get the top left corner of the portRect in        */
        /* global coords, since the strucRgn is in global coords.  We       */
        /* want to know how far the portRect is inset from the strucRgn     */
        /* because the MoveWindow trap operates on the portRect, not the    */
        /* strucRgn.                                                        */
        
    GetPort(&savePort);
    SetPort(macPort);
    portTopLeft = topLeft(macPort->portRect);
    LocalToGlobal(&portTopLeft);
    SetPort(savePort);
    
	theRect->left = portTopLeft.h;
	theRect->top = portTopLeft.v;
	theRect->right = macPort->portRect.right - macPort->portRect.left;
	theRect->bottom = macPort->portRect.bottom - macPort->portRect.top;
}
